//
//  MainViewController.m
//  ShargooSDKDemo
//
//  Created by Twinkleo on 2020/7/31.
//  Copyright © 2020 Twinkleo. All rights reserved.
//

#import "MainViewController.h"

#import <Shargoo/Shargoo.h>

#import "OtherViewController.h"

@interface MainViewController ()

@end

@implementation MainViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initSet];
    [self initSubViews];
}

- (void) btnClick:(UIButton *) sender {
    if (sender.tag == 0) {
        XGFaceDetectionViewController *controller = [[XGFaceDetectionViewController alloc] init];
        controller.faceType = 0;
        controller.faceDetectionBlock = ^(id  _Nonnull backData, UIViewController * _Nonnull controller) {
            NSLog(@"活体检测%@", backData);
            [controller.navigationController popViewControllerAnimated:YES];
        };
        [self.navigationController pushViewController:controller animated:YES];
        return;
    }
    
    if (sender.tag == 1) {
        XGIDCardDetectionViewController *controller = [[XGIDCardDetectionViewController alloc] init];
        controller.idCardDetectionBlock = ^(id  _Nonnull backData, UIViewController * _Nonnull infoController) {
            NSLog(@"身份证证件识别%@", backData);
            [infoController.navigationController popToRootViewControllerAnimated:YES];
        };
        [self.navigationController pushViewController:controller animated:YES];
        return;
    }
    
    if (sender.tag == 2) {
        XGFaceDetectionTipViewController *controller = [[XGFaceDetectionTipViewController alloc] init];
        controller.idCardNameStr = @"张三";
        controller.idCardNumberStr = @"XXXXXXXXXXXXXXXXXX";
        controller.faceDetectionTipBlock = ^(id  _Nonnull backData, UIViewController * _Nonnull controller) {
            NSLog(@"人脸核身结果%@", backData);
            [controller.navigationController popToRootViewControllerAnimated:YES];
        };
        [self.navigationController pushViewController:controller animated:YES];
        return;
    }
    
    if (sender.tag == 3) {
        XGMVRCDetectionViewController *controller = [[XGMVRCDetectionViewController alloc] init];
        controller.MVRCDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller) {
            NSLog(@"机动车登记证识别结果%@", backData);
            [controller.navigationController popToRootViewControllerAnimated:YES];
        };
        [self.navigationController pushViewController:controller animated:YES];
        return;
    }
    
    if (sender.tag == 4) {
        XGLPDetectionViewController *controller = [[XGLPDetectionViewController alloc] init];
        controller.LPDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller, BOOL manuallyInput) {
            if (manuallyInput) {
//                跳转到一个新的输入车牌的页面
                NSLog(@"跳转到一个新的输入车牌的页面");
                OtherViewController *vc = [[OtherViewController alloc] init];
                vc.title = @"手动输入车牌号页面";
                [controller.navigationController pushViewController:vc animated:YES];
            } else {
                NSLog(@"车牌识别结果%@", backData);
                [controller.navigationController popToRootViewControllerAnimated:YES];
            }
        };
        [self.navigationController pushViewController:controller animated:YES];
        return;
    }
    
    if (sender.tag == 5) {
        XGVINDetectionViewController *controller = [[XGVINDetectionViewController alloc] init];
        controller.VINDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller, BOOL manuallyInput) {
            if (manuallyInput) {
//                跳转到一个新的输入VIN的页面
                NSLog(@"跳转到一个新的输入VIN的页面");
                OtherViewController *vc = [[OtherViewController alloc] init];
                vc.title = @"手动输入VIN码页面";
                [controller.navigationController pushViewController:vc animated:YES];
            } else {
                NSLog(@"VIN识别结果%@", backData);
                [controller.navigationController popToRootViewControllerAnimated:YES];
            }
        };
        [self.navigationController pushViewController:controller animated:YES];
        return;
    }
    
    if (sender.tag == 6) {
        XGVCDetectionViewController *controller = [[XGVCDetectionViewController alloc] init];
        controller.XGVCDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller) {
            NSLog(@"车辆合格证识别结果%@", backData);
            [controller.navigationController popToRootViewControllerAnimated:YES];
        };
        [self.navigationController pushViewController:controller animated:YES];
        return;
    }
    
    if (sender.tag == 7) {
        XGVLDetectionViewController *controller = [[XGVLDetectionViewController alloc] init];
        controller.XGVLDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller) {
            NSLog(@"行驶证识别结果%@", backData);
            [controller.navigationController popToRootViewControllerAnimated:YES];
        };
        [self.navigationController pushViewController:controller animated:YES];
        return;
    }
    
    if (sender.tag == 8) {
        XGIODetectionViewController *controller = [[XGIODetectionViewController alloc] init];
        controller.XGIODetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller) {
            NSLog(@"发票识别结果%@", backData);
            [controller.navigationController popToRootViewControllerAnimated:YES];
        };
        [self.navigationController pushViewController:controller animated:YES];
        return;
    }
    
    if (sender.tag == 9) {
        XGBLDetectionViewController *controller = [[XGBLDetectionViewController alloc] init];
        controller.XGBLDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller) {
            NSLog(@"营业执照识别结果%@", backData);
            [controller.navigationController popToRootViewControllerAnimated:YES];
        };
        [self.navigationController pushViewController:controller animated:YES];
        return;
    }

}

- (void) initSubViews {
    self.view.backgroundColor = [UIColor whiteColor];
    self.title = @"ShargooData";
    NSArray *titleArr = @[
        @"活体检测",
        @"身份证证件识别",
        @"人脸核身",
        @"机动车登记证识别",
        @"车牌识别",
        @"VIN识别",
        @"车辆合格证",
        @"行驶证识别",
        @"发票",
        @"营业执照",
    ];
    for (int i = 0; i < titleArr.count; i ++) {
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
        btn.frame = CGRectMake(20, 100 + 60 *i, self.view.frame.size.width - 40, 40);
        btn.backgroundColor = [UIColor grayColor];
        [btn setTitle:titleArr[i] forState:UIControlStateNormal];
        btn.titleLabel.font = [UIFont systemFontOfSize:14];
        btn.tag = i;
        [btn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        [self.view addSubview:btn];
    }
}

- (void) initSet {
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
        
//    token  必传
    [defaults setObject:@"eyJhbGciOiJIUzUxMiJ9.eyJhdWQiOiJTMDA0MyIsImlzcyI6InNkeJnb29kYXRhIiwibmFtZSI6IuadreW3nuyTpuiwt-aZuuiDveenkeaKgOaciemZkOWFrOWPuCIsImV4cCI6MTczOTEwMzQ4Mn0.5KuHgEdUY4WouvkexHIPR-6s_Nfun3tad3DXQUMOwnbEwVzYx0bq_dLr5IwGXiqh2Oq4SKUZWPotMnrCzKa__yw" forKey:@"XG_TOKEN"];
        
//    订单号（唯一标识符）必传，例如公司名称
    [defaults setObject:@"Shargoo_iOS_Release" forKey:@"XG_OUTSIDE_NO"];
    
//    商户号   必传
    [defaults setObject:@"S0001" forKey:@"XG_PLATFORMNO"];
        
    [defaults synchronize];
}

@end
