#### SDK版本

SDK版本    v2.0
文档版本    v2.0
修改时间    2025年01月13日

#### 使用授权声明

本⽂文档中所包含的信息属于商业机密信息，应严格控制使用范围。如⽆杭州学谷数据智能有限公司的书⾯许可，任何人员不得以任何方式持有或使用本⽂文档的部分或全部内容。

#### ⽂档说明

本文所指的《学谷智能iOS端SDK对接文档》是针对iOS端接口对接的详细说明⽂档。
##### 功能描述

商户通过调⽤SDK服务接口，实现活体检测、身份证证件识别、人脸比对、机动车登记证书识别等功能。
##### 阅读对象

iOS端开发⼈员以及相关项⽬管理⼈员。
技术服务

在开发或使用接口时，产⽣疑问或出现问题，可通过QQ、微信、Email、⼿机等联系相关技术人员，相关人员会及时处理。
### 集成准备及配置⼯作

1，请在您的工程目录结构中，将ShargooSDK文件夹添加到您的项目中。 
2，拖放后一般会在 ``‘Build Settings - Search Paths - Framework Search Paths’``中存在指向ShargooSDK的根⽬录路径`` $(PROJECT_DIR)``，一般情况下这个路径会自动填充，如若没有填充， 请手动填充指向存放ShargooSDK的路径。 
3，在``Targets-General-Frameworks``中添加``Accelerate.framework`` 
4，在``Target-Build Settings-Linking-Other Linker Flags``中添加``-ObjC、-force_load、ShargooTensorflow``的对应路径``"$(SRCROOT)/ShargooSDKDemo/ShargooSDK/ShargooTensorflow.a"``
5，在``Target-Build Settings``中将``Enable Bitcode``设置为NO 
6，请在info.plist⾥添加使用相机权限和App Transport Security Settings 1)，``Privacy - Camera Usage Description`` 2，``App Transport Security Settings（添加Allow Arbitrary Loads并设为YES）``
7，引用SDK`` #import <Shargoo/Shargoo.h>``
8，需要使用接口的页面，将.m改为.mm
9，请使用真机进行测试开发
#### 接口列表

##### （一），活体检测

##### （二），身份证证件识别

##### （三），人脸核身

##### （四），机动车登记证书识别

##### （五），车牌识别

##### （六），VIN码识别

##### （七），车辆合格证

##### （八），行驶证

##### （九），发票

##### （十），营业执照

⚠️使用SDK需要使用Token、订单号、商户号， 均由商户提供，请以NSUserDefaults方式保存，key分别为“XG_TOKEN”、“XG_OUTSIDE_NO”、“XG_PLATFORMNO”，若key不一致，SDK中将无法获取Token、订单号、商户号，建议使用SDK相应接口前获取Token并保存，Token有效时间为10分钟。
```
NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
//    token
[defaults setObject:@"XXXXX" forKey:@"XG_TOKEN"];

//    订单号（唯一标识，英文或数字，不超过64位字符，例如 Shargoo_iOS，尽量保持唯一 ）
[defaults setObject:@"XXXXX" forKey:@"XG_OUTSIDE_NO"];

//    商户号
[defaults setObject:@"XXXXX" forKey:@"XG_PLATFORMNO"];

[defaults synchronize];
```
#### 一，活体检测

启动页面XGFaceDetectionViewController
```
XGFaceDetectionViewController *controller = [[XGFaceDetectionViewController alloc] init];
//单纯的活体检测 faceType请传0
controller.faceType = 0;
//回调结果的处理，活体检测成功后会返回backData（含有成功的状态码及获得的最后一张照片）
//商户可对回调中的controller进行操作，自行处理结果处理页面
controller.faceDetectionBlock = ^(id  _Nonnull backData, UIViewController * _Nonnull controller) {
    NSLog(@"单纯活体检测%@", backData);

//  识别后返回当前页面 
//  [controller.navigationController popViewControllerAnimated:YES];

//  识别后跳转某页面
//  [controller.navigationController pushViewController:XXXController animated:YES];

};
[self.navigationController pushViewController:controller animated:YES];
```
#### 二，身份证证件识别

启动页面XGIDCardDetectionViewController
```
XGIDCardDetectionViewController *controller = [[XGIDCardDetectionViewController alloc] init];
//进入身份证识别页面按照提示拍摄身份证正反面后
//backData中包含所识别的结果，商户可自行处理结果并处理页面
controller.idCardDetectionBlock = ^(id  _Nonnull backData, UIViewController * _Nonnull infoController) {
    NSLog(@"单纯身份证证件识别%@", backData);

//  识别后返回当前页面 
//  [controller.navigationController popViewControllerAnimated:YES];

//  识别后跳转某页面
//  [controller.navigationController pushViewController:XXXController animated:YES];
};
[self.navigationController pushViewController:controller animated:YES];
```
#### 三，人脸核身

启动页面XGFaceDetectionTipViewController
```
XGFaceDetectionTipViewController *controller = [[XGFaceDetectionTipViewController alloc] init];
controller.idCardNameStr = @"张三";
controller.idCardNumberStr = @"350321096003237001";
//backData中包含失败或成功的结果
controller.faceDetectionTipBlock = ^(id  _Nonnull backData, UIViewController * _Nonnull controller) {
     NSLog(@"手动输入身份证号和姓名后进行人脸比对%@", backData);

//  识别后返回当前页面 
//  [controller.navigationController popViewControllerAnimated:YES];

//  识别后跳转某页面
//  [controller.navigationController pushViewController:XXXController animated:YES];
};
[self.navigationController pushViewController:controller animated:YES];
```

#### 四，机动车登记证书识别

启动页面XGMVRCDetectionViewController
```
XGMVRCDetectionViewController *controller = [[XGMVRCDetectionViewController alloc] init];
controller.MVRCDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller) {
    NSLog(@"机动车登记证识别结果%@", backData);
    [controller.navigationController popToRootViewControllerAnimated:YES];
};
[self.navigationController pushViewController:controller animated:YES];

### data参数说明：

参数名    说明
- res    OCR识别结果
- code    识别状态码
- num    识别数量
- page    0代表信息栏 1代表登记栏

### code参数说明：

参数名    说明
- 001    识别成功
- 002    非jpg png图片
- 003    图片遮挡,模糊,不完整,内容不符合要求
```
#### 五，车牌识别

启动页面XGLPDetectionViewController
```
XGLPDetectionViewController *controller = [[XGLPDetectionViewController alloc] init];
controller.LPDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller, BOOL manuallyInput) {
     if (manuallyInput) {
//        跳转到一个新的输入车牌的页面
           OtherViewController *vc = [[OtherViewController alloc] init];
           [controller.navigationController pushViewController:vc animated:YES];
      } else {
           NSLog(@"车牌识别结果%@", backData);
           [controller.navigationController popToRootViewControllerAnimated:YES];
      }
};
[self.navigationController pushViewController:controller animated:YES];
```
#### 六，VIN码识别

启动页面XGVINDetectionViewController
```
XGVINDetectionViewController *controller = [[XGVINDetectionViewController alloc] init];
controller.VINDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller, BOOL manuallyInput) {
     if (manuallyInput) {
//       跳转到一个新的输入VIN的页面
          OtherViewController *vc = [[OtherViewController alloc] init];
          [controller.navigationController pushViewController:vc animated:YES];
      } else {
          NSLog(@"VIN识别结果%@", backData);
          [controller.navigationController popToRootViewControllerAnimated:YES];
     }
};
[self.navigationController pushViewController:controller animated:YES];
```

#### 七，车辆合格证

启动页面XGVCDetectionViewController
```
XGVCDetectionViewController *controller = [[XGVCDetectionViewController alloc] init];
controller.XGVCDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller) {
    NSLog(@"车辆合格证识别结果%@", backData);
    [controller.navigationController popViewControllerAnimated:YES];
};
[self.navigationController pushViewController:controller animated:YES];
```

#### 八，行驶证

启动页面XGVLDetectionViewController
```
XGVLDetectionViewController *controller = [[XGVLDetectionViewController alloc] init];
controller.XGVLDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller) {
    NSLog(@"行驶证识别结果%@", backData);
    [controller.navigationController popViewControllerAnimated:YES];
};
[self.navigationController pushViewController:controller animated:YES];
```

#### 九，发票

启动页面XGIODetectionViewController 
```
XGIODetectionViewController *controller = [[XGIODetectionViewController alloc] init];
controller.XGIODetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller) {
    NSLog(@"发票识别结果%@", backData);
    [controller.navigationController popViewControllerAnimated:YES];
};
[self.navigationController pushViewController:controller animated:YES];
```

#### 十，营业执照

启动页面XGBLDetectionViewController
```
XGBLDetectionViewController *controller = [[XGBLDetectionViewController alloc] init];
controller.XGBLDetectionBlock = ^(id  _Nonnull backData, UIImage * _Nonnull image, UIViewController * _Nonnull controller) {
    NSLog(@"营业执照识别结果%@", backData);
    [controller.navigationController popViewControllerAnimated:YES];
};
[self.navigationController pushViewController:controller animated:YES];
```
